/*! \file tlk_odrm_types.h
**********************************************************************************
*Title:                        Discretix OMA DRM v2 Toolkit header file
*
* Filename:                     tlk_odrm_types.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      20.11.2007
*
* Modified:                     20.11.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_TYPES_H_
#define _TLK_ODRM_TYPES_H_

/*----------- Global Includes ------------------------------------------------*/
#include "CRYS_AES.h"
#include "CRYS_RSA_Types.h"
#include "CRYS_CMLA.h"
#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif


/*----------- Global type definitions ----------------------------------------*/
/*!
\brief  This structure describes general buffer structure.

**/typedef struct
{
    DxByte_t                         *buff_ptr;                     /*!<buff_ptr                             - A pointer to the general buffer                                           **/
    DxUint32_t                        buffSizeInBytes;              /*!<buffSizeInBytes                      - A length of the general buffer                                            **/
}TLK_ODRM_Buffer_t;


/*!
\brief  This structure describes parameters for access certain key ring 
**/
typedef struct
{
    DxUint8_t                         *keyKmngRingPassword_ptr;         /*!<keyRingPassword_ptr                 - A password for access to key ring                                        **/
    DxUint32_t                         keyKmngRingPasswordLenInBytes;   /*!<keyRingPasswordLenInBytes           - A key ring password length                                               **/
    DxUint8_t                         *keyKmngRing_ptr;                     /*!<keyRing_ptr                         - A key ring                                                               **/
}TLK_ODRM_KMNGKeyRing_t; 

    
/*!
\brief  This structure describes parameters for protected certain key in KMNG terms.

**/
typedef struct
{
    DxUint8_t                         *keyPassword_ptr;             /*!<keyPassword_ptr                     - A password for access to key data in KMNG environment                    **/
    DxUint32_t                         keyPasswordLenInBytes;       /*!<keyPasswordLenInBytes               - A key password length                                                    **/
    DxUint32_t                         keyId;                       /*!<keyId                               - An Id of the key in the key ring  in KMNG environment                    **/
}TLK_ODRM_KMNGKey_t;



/*!
\brief  This structure describes general key structure.

**/typedef struct
{
    TLK_ODRM_Buffer_t                  keyKmngPassword;       /*!<keyKmngPassword               - The key password in the KMNG                                              **/
    TLK_ODRM_Buffer_t                  key;                   /*!<key                           - The wrapped presentation of key for KMNG                                  **/
}TLK_ODRM_Key_t;

/*!
\brief  This typedef used for domain generation number definition.

**/
typedef  DxUint32_t               TLK_ODRM_DomainGeneration_t;
   
/*!
\brief This enumerator describes the different Toolkit OMA DRM operations that require workspace.
**/
typedef enum 
{
    TLK_ODRM_MIN_WORKSPACE      = 0,

    TLK_ODRM_WORKSPACE_OP_LAST  = 0x7FFFFFFF
}TLK_ODRMWorkspaceOp_t;


typedef enum 
{
	DX_ENCR_NULL,
	DX_ENCR_AES_128_CBC,
	DX_ENCR_AES_128_CTR,
} TLK_ODRM_GROUP_KEY_ENCRYPTION_TYPE;

#ifdef __cplusplus
}
#endif /*extern "C"*/
#endif

